using System;

namespace com.swvoyages.reservation {

	///
	/// <summary>Cette exception est lance en cas de problme de 
	/// rservation.</summary>
	///
	public class ReservationException : ApplicationException {

		///
		/// <summary>Ce constructeur permet de crer une exception de 
		/// rservation sans message d'anomalie associ.</summary>
		///
		public ReservationException() : base() {
		}

		///
		/// <summary>Ce constructeur permet de crer une exception de 
		/// rservation avec un message d'anomalie associ.</summary>
		///
		/// <param name="message">le message d'anomalie associ</param>
		///
		public ReservationException(String message) : base(message) {
		}

		///
		/// <summary>Ce constructeur permet de crer une exception de 
		/// rservation avec un message d'anomalie associ et d'y ajouter 
		/// l'exception systme  l'origine de cette exception de rservation.
		/// </summary>
		///
		/// <param name="message">le message d'anomalie associ</param>
		/// <param name="rootCause">l'exception systme  l'origine de 
		///	cette exception de rservation</param>
		///
		public ReservationException(String message, Exception rootCause) : base(message, rootCause) {
		}

		///
		/// <summary>Ce constructeur permet de crer une exception de 
		/// rservation et d'y ajouter un message d'anomalie relatif  
		/// l'exception systme  l'origine de cette exception de rservation.
		/// </summary>
		///
		/// <param name="rootCause">l'exception systme  l'origine de 
		///	cette exception de rservation</param>
		///
		public ReservationException(Exception rootCause) : this (rootCause.Message) {
		}

		///
		/// <summary>Renvoie l'exception systme <code>Exception</code> 
		///  l'origine de cette exception de rservation.</summary> 
		///
		/// <returns>l'exception systme <code>Exception</code> 
		///  l'origine de cette exception de rservation</returns>
		///
		public Exception getRootCause() {
			return InnerException;
		}
		
		///
		/// <summary>Renvoie le message d'anomalie associ  cette 
		/// exception de rservation.</summary> 
		///
		/// <returns>le message d'anomalie</returns>
		///
		public override String ToString() {
			return Message;
		}
	}
}